/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseEcRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseEcResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import java.util.Date;

public class EcLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseEcRequest, LakalaBaseEcResponse> {
    private static SerializeConfig serializeConfig = new SerializeConfig();

    public EcLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public EcLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseEcResponse<T> execute(LakalaBizRequest<T, R> request, R merchantApiDefinitionEnum) throws LakalaApiException {
        return (LakalaBaseEcResponse)super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseEcRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        LakalaBaseEcRequest<LakalaBizRequest> request = new LakalaBaseEcRequest<LakalaBizRequest>();
        Date now = new Date();
        request.setReqTime(DateUtil.format((Date)now, (String)"yyyyMMddHHmmss"));
        request.setTimestamp(now.getTime());
        request.setRnd(RandomUtil.randomString((int)12));
        request.setVersion(merchantApiDefinitionEnum.getVersion());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseEcRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseEcRequest lakalaBaseRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseEcResponse parseResponse(String resBody, ILakalaApiDefinition merchantApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("resp_data", merchantApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"resp_data");
        LakalaBaseEcResponse response = (LakalaBaseEcResponse)resJson.toJavaObject(LakalaBaseEcResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        EcLakalaApiClientImpl.serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

