/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.enums.activity.LakalaActivityApiDefinitionEnum;
import com.fshows.lakala.enums.activity.LakalaActivityResponseCodeEnum;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseActivityRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.activity.LakalaActivityApplyResponse;
import com.fshows.lakala.response.activity.LakalaActivityPackageQueryResponse;
import com.fshows.lakala.response.base.LakalaBaseActivityResponse;
import com.fshows.lakala.response.base.LakalaBaseResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.LkalDateUtil;
import com.fshows.lakala.util.ReqIdUtil;
import java.util.Date;
import java.util.List;

public class ActivityLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseActivityRequest, LakalaBaseActivityResponse> {
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public ActivityLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public ActivityLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseResponse<T> execute(LakalaBizRequest<T, R> request, R activityApiDefinitionEnum) throws LakalaApiException {
        return super.doExecute(request, activityApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseActivityRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition activityApiDefinitionEnum) {
        LakalaBaseActivityRequest<LakalaBizRequest> request = new LakalaBaseActivityRequest<LakalaBizRequest>();
        request.setReqTime(new Date());
        request.setVersion(activityApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseActivityRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setTimeStamp(LkalDateUtil.formatToTimeStamp(lakalaBaseRequest.getReqTime()));
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseActivityRequest lakalaBaseRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseActivityResponse parseResponse(String resBody, ILakalaApiDefinition tradeApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        if (tradeApiDefinitionEnum.getApiSubURI().contains(LakalaActivityApiDefinitionEnum.APPLY.getApiSubURI()) && resJson.getString("code").equals(LakalaActivityResponseCodeEnum.SUCCESS.getValue())) {
            LakalaBaseActivityResponse<LakalaActivityApplyResponse> response = new LakalaBaseActivityResponse<LakalaActivityApplyResponse>();
            response.setMsg(resJson.getString("msg"));
            response.setCode(resJson.getString("code"));
            LakalaActivityApplyResponse lakalaActivityApplyResponse = new LakalaActivityApplyResponse();
            lakalaActivityApplyResponse.setEnrollId(resJson.getString("resp_data"));
            response.setRespData(lakalaActivityApplyResponse);
            return response;
        }
        if (tradeApiDefinitionEnum.getApiSubURI().contains(LakalaActivityApiDefinitionEnum.PACKAGE_QUERY.getApiSubURI()) && resJson.getString("code").equals(LakalaActivityResponseCodeEnum.SUCCESS.getValue())) {
            LakalaBaseActivityResponse response = new LakalaBaseActivityResponse();
            response.setMsg(resJson.getString("msg"));
            response.setCode(resJson.getString("code"));
            List list = JSONObject.parseArray((String)resJson.getString("resp_data"), LakalaActivityPackageQueryResponse.class);
            response.setRespDataList(list);
            return response;
        }
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("resp_data", tradeApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"resp_data");
        LakalaBaseActivityResponse response = (LakalaBaseActivityResponse)resJson.toJavaObject(LakalaBaseActivityResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        ActivityLakalaApiClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

