/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaEwalletSettleProfileResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 账管家提款模式设置
 *
 * @author liluqing
 * @version LakalaEwalletSettleProfileRequest.java, v 0.1 2022-03-08 10:22
 */
@Data
public class LakalaEwalletSettleProfileRequest extends LakalaBizRequest<LakalaEwalletSettleProfileResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = 7160324677427166072L;

    /**
     * BMCP机构号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "BMCP机构号长度不能超过32")
    private String bmcpNo;

    /**
     * 822商户号 或 receiveNo	 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "822商户号 或 receiveNo长度不能超过32")
    private String mercId;
    /**
     * 提款模式（01主动提款 02自动结算） (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "提款模式长度不能超过32")
    private String settleType;

    /**
     * 交易自动结算周期（D1/T1），针对03交易自动结算生效
     */
    private String settleCircle;

    /**
     * 结算时间（小时）- 默认值：06。如08:00-09:00到账，则传入08。
     */
    private String settleTime;
    /**
     * 提款通知URL
     * 提款模式02生效
     */
    private String notifyUrl;
    /**
     * 留存金额(单位：元) 提款模式02生效
     */
    private String retainedAmt;
    /**
     * 备注
     */
    private String remark;
    /**
     * 摘要
     */
    private String summary;
    /**
     * 合并类型：AC-结算账号合并,NO-不合并。默认值：AC。只适用于03交易自动结算
     */
    private String mergeType;
}