/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaEcQueryApplyManualStatusResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoxumin
 * @version LakalaEcQueryApplyManualStatusRequest.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcQueryApplyManualStatusRequest extends LakalaBizRequest<LakalaEcQueryApplyManualStatusResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 6692261423200790784L;
    /**
     * 四方机构自定义订单编号 (必填参数)
     * 建议：平台编号+14位年月日时（24小时制）分秒+8位的随机数（同一接入机构不重复）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构号 (必填参数)
     */
    @NotNull(message = "机构号不能为空")
    private Integer orgId;

    /**
     * 电子合同申请受理号 (必填参数)
     * 申请接口反馈编号
     */
    @NotNull(message = "电子合同申请受理号不能为空")
    private Long ecApplyId;
}