/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaEcApplyResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoxumin
 * @version LakalaEcApplyRequest.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcApplyRequest extends LakalaBizRequest<LakalaEcApplyResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = -1826439203263715891L;

    /**
     * 四方机构自定义订单编号 (必填参数)
     * 建议：平台编号+14位年月日时（24小时制）分秒+8位的随机数（同一接入机构不重复）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构号 (必填参数)
     */
    @NotNull(message = "机构号不能为空")
    private Integer orgId;

    /**
     * 合同类别 (必填参数)
     * EC001 : 特约商户支付服务合作协议V3.1(商户入网)
     * EC002 : 特约商户支付服务合作协议V3.2（商户入网+分账）
     * EC003 : 分账结算授权委托书
     * EC004 : 特约商户支付服务合作协议V3.3（商户入网）
     * EC005 : 特约商户支付服务合作协议V3.3（商户入网+分账）
     * EC007 : 特约商户支付服务合作协议V4.1 + 结算授权委托书 (商户入网 + 分账)
     * EC008 : 特约商户支付服务合作协议V4.1 (商户入网)
     * EC009 : 结算授权委托书
     */
    @NotBlank
    @Length(max = 12, message = "合同类别长度不能超过12")
    private String ecTypeCode;

    /**
     * 法人/经营者证件类型 (必填参数)
     * RESIDENT_ID（身份证）；
     * PASSPORT（护照）；
     * HK_MACAO_PASS（港澳居民往来内地通行证）；
     * TAIWAN_PASS（台湾居民来往大陆通行证）；
     */
    @NotBlank
    @Length(max = 16, message = "证件类型长度不能超过16")
    private String certType;

    /**
     * 法人/经营者姓名 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "法人/经营者姓名长度不能超过32")
    private String certName;

    /**
     * 法人/经营者证件号码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "证件号码长度不能超过32")
    private String certNo;

    /**
     * 签约手机号 (必填参数)
     * 小微个人商户（无营业执照），签约手机号必须填写商户经营者本人手机号；
     * 个体工商户或企业商户（有营业执照），签约手机号必须填写法人手机号或者经办人手机号
     */
    @NotBlank
    @Length(max = 16, message = "签约手机号长度不能超过16")
    private String mobile;

    /**
     * 营业执照号 (可选参数)
     */
    @Length(max = 32, message = "营业执照号长度不能超过32")
    private String businessLicenseNo;

    /**
     * 营业执照名称 (可选参数)
     */
    @Length(max = 32, message = "营业执照名称长度不能超过32")
    private String businessLicenseName;

    /**
     * 企业/经营者结算开户行号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "开户行号长度不能超过32")
    private String openningBankCode;

    /**
     * 企业/经营者结算开户行名称 (必填参数)
     */
    @NotBlank
    @Length(max = 128, message = "开户行名称长度不能超过128")
    private String openningBankName;

    /**
     * 企业/经营者结算卡性质 (必填参数)
     * 57 对公、 58 对私
     */
    @NotBlank
    @Length(max = 2, message = "结算卡性质长度不能超过2")
    private String acctTypeCode;

    /**
     * 企业/经营者结算卡号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "结算卡号长度不能超过32")
    private String acctNo;

    /**
     * 企业/经营者结算卡名称 (必填参数)
     */
    @NotBlank
    @Length(max = 64, message = "结算卡名称长度不能超过64")
    private String acctName;

    /**
     * 电子合同内容参数集合 (必填参数)
     * 按合同类型（ecTypeCode）传递不同的参数集合
     */
    @NotBlank
    private String ecContentParameters;

    /**
     * 是否经办签约 (可选参数)
     * 0 不启用 1启用
     */
    private Integer agentTag;

    /**
     * 经办人名称 (可选参数)
     * agentTag 为1时 必传
     */
    @Length(max = 32, message = "经办人名称长度不能超过32")
    private String agentName;

    /**
     * 经办人证件类型 (可选参数)
     * agentTag 为1时 必传
     */
    @Length(max = 32, message = "经办人证件类型长度不能超过32")
    private String agentCertType;

    /**
     * 经办人证件号 (可选参数)
     * agentTag 为1时 必传
     */
    @Length(max = 32, message = "经办人证件号长度不能超过32")
    private String agentCertNo;

    /**
     * 经办签约授权委托书文件名 (可选参数)
     * agentTag 为1时 必传
     */
    @Length(max = 32, message = "授权委托书文件名长度不能超过32")
    private String agentFileName;

    /**
     * 经办授权委托书文件路径 (可选参数)
     * agentTag 为1时 必传
     */
    @Length(max = 128, message = "授权委托书文件路径长度不能超过128")
    private String agentFilePath;

    /**
     * 备注说明 (可选参数)
     */
    @Length(max = 128, message = "备注说明长度不能超过128")
    private String remark;

    /**
     * 电子合同签约结果回调通知 (必填参数)
     * 成功签约才通知
     */
    @NotBlank
    @Length(max = 128, message = "回调通知长度不能超过128")
    private String retUrl;
}