package com.fshows.lakala.enums.trade;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.trade.order.LakalaBankPayOrderQueryRequest;
import com.fshows.lakala.request.trade.order.LakalaBankPayTransQueryRequest;
import com.fshows.lakala.request.trade.order.LakalaCloseRequest;
import com.fshows.lakala.request.trade.order.LakalaOrderQueryRequest;
import com.fshows.lakala.request.trade.order.LakalaQueryRateFeeRequest;
import com.fshows.lakala.request.trade.order.LakalaRefundRequest;
import com.fshows.lakala.request.trade.order.LakalaRevokeRequest;
import com.fshows.lakala.request.trade.pay.LakalaBankPayCreateOrderRequest;
import com.fshows.lakala.request.trade.pay.LakalaPreOrderCreateRequest;
import com.fshows.lakala.request.trade.pay.LakalaScanCardRequest;
import com.fshows.lakala.response.trade.order.LakalaBankPayOrderQueryResponse;
import com.fshows.lakala.response.trade.order.LakalaBankPayTransQueryResponse;
import com.fshows.lakala.response.trade.order.LakalaCloseResponse;
import com.fshows.lakala.response.trade.order.LakalaOrderQueryResponse;
import com.fshows.lakala.response.trade.order.LakalaQueryRateFeeResponse;
import com.fshows.lakala.response.trade.order.LakalaRefundResponse;
import com.fshows.lakala.response.trade.order.LakalaRevokeResponse;
import com.fshows.lakala.response.trade.pay.LakalaBankPayCreateOrderResponse;
import com.fshows.lakala.response.trade.pay.LakalaPreOrderCreateResponse;
import com.fshows.lakala.response.trade.pay.LakalaScanCardResponse;

/**
 * 拉卡拉交易相关API
 *
 * @author liluqing
 * @version LakalaTradeApiEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaTradeApiDefinitionEnum implements ILakalaApiDefinition {
    PRE_ORDER_CREATE(
            "主扫交易（统一下单接口）",
            "api/v3/labs/trans/preorder",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaPreOrderCreateRequest.class,
            LakalaPreOrderCreateResponse.class
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "api/v3/labs/trans/micropay",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaScanCardRequest.class,
            LakalaScanCardResponse.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "api/v3/labs/relation/refund",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaRefundRequest.class,
            LakalaRefundResponse.class
    ),
    REVOKED_CREATE(
            "撤销交易",
            "api/v3/labs/relation/revoked",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaRevokeRequest.class,
            LakalaRevokeResponse.class
    ),
    ORDER_CLOSE(
            "关单交易",
            "api/v3/labs/relation/close",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaCloseRequest.class,
            LakalaCloseResponse.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "api/v3/labs/query/tradequery",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaOrderQueryRequest.class,
            LakalaOrderQueryResponse.class
    ),
    QUERY_RATE_FEE(
            "订单手续费查询接口",
            "api/v3/lams/merchant/query_trans",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaQueryRateFeeRequest.class,
            LakalaQueryRateFeeResponse.class
    ),
    BANK_PAY_CREATE_ORDER(
            "刷卡支付预下单接口（银行卡支付）",
            "api/v3/los/checkout_counter/mch_create_order",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaBankPayCreateOrderRequest.class,
            LakalaBankPayCreateOrderResponse.class
    ),
    BANK_PAY_ORDER_QUERY(
            "订单交易信息查询（银行卡支付）",
            "api/v3/los/checkout_counter/query_order",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaBankPayOrderQueryRequest.class,
            LakalaBankPayOrderQueryResponse.class
    ),
    BANK_PAY_REFUND_QUERY(
            "订单退款查询（银行卡支付）",
            "api/v3/searcher/base_core/trans_query",
            LakalaConstant.TRADE_API_VERSION_V3,
            LakalaBankPayTransQueryRequest.class,
            LakalaBankPayTransQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    LakalaTradeApiDefinitionEnum(String name,
                                 String apiSubURI,
                                 String version,
                                 Class requestClass,
                                 Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}