/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.lakala.client.base.*;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.enums.activity.LakalaActivityApiDefinitionEnum;
import com.fshows.lakala.enums.activity.LakalaActivityResponseCodeEnum;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseActivityRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.activity.LakalaActivityApplyResponse;
import com.fshows.lakala.response.activity.LakalaActivityPackageQueryResponse;
import com.fshows.lakala.response.base.LakalaBaseActivityResponse;
import com.fshows.lakala.response.base.LakalaBaseResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.LkalDateUtil;
import com.fshows.lakala.util.ReqIdUtil;

import java.util.Date;
import java.util.List;

/**
 * @author zhoujp
 * @version ActivityLakalaApiClientImpl.java, v 0.1 2023-05-15 14:48 zhoujp
 */
public class ActivityLakalaApiClientImpl extends AbstractLakalaApiClientImpl<LakalaBaseActivityRequest, LakalaBaseActivityResponse> {

    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    static {
        SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }

    public ActivityLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public ActivityLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }


    @Override
    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseResponse<T> execute(LakalaBizRequest<T, R> request, R activityApiDefinitionEnum) throws LakalaApiException {
        return super.doExecute(request, activityApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseActivityRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition activityApiDefinitionEnum) {
        LakalaBaseActivityRequest request = new LakalaBaseActivityRequest();
        request.setReqTime(new Date());
        request.setVersion(activityApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseActivityRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setSerialNo(apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setTimeStamp(LkalDateUtil.formatToTimeStamp(lakalaBaseRequest.getReqTime()));
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseActivityRequest lakalaBaseRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString(lakalaBaseRequest, SNAKE_CASE_CONFIG);
    }

    @Override
    protected LakalaBaseActivityResponse parseResponse(String resBody, ILakalaApiDefinition tradeApiDefinitionEnum) {

        JSONObject resJson = JSONObject.parseObject(resBody);
        //活动报名接口返回参数需要特殊处理
        if (tradeApiDefinitionEnum.getApiSubURI().contains(LakalaActivityApiDefinitionEnum.APPLY.getApiSubURI()) && resJson.getString("code").equals(LakalaActivityResponseCodeEnum.SUCCESS.getValue())) {
            LakalaBaseActivityResponse response = new LakalaBaseActivityResponse();
            response.setMsg(resJson.getString("msg"));
            response.setCode(resJson.getString("code"));
            LakalaActivityApplyResponse lakalaActivityApplyResponse = new LakalaActivityApplyResponse();
            lakalaActivityApplyResponse.setEnrollId(resJson.getString(LakalaConstant.LAKALA_TRADE_RESPONSE_BIZ_KEY));
            response.setRespData(lakalaActivityApplyResponse);
            return response;
        } else if (tradeApiDefinitionEnum.getApiSubURI().contains(LakalaActivityApiDefinitionEnum.PACKAGE_QUERY.getApiSubURI())
                  && resJson.getString("code").equals(LakalaActivityResponseCodeEnum.SUCCESS.getValue())) {
            LakalaBaseActivityResponse<LakalaActivityPackageQueryResponse> response = new LakalaBaseActivityResponse<>();
            response.setMsg(resJson.getString("msg"));
            response.setCode(resJson.getString("code"));
            List<LakalaActivityPackageQueryResponse> list = JSONObject.parseArray(
                    resJson.getString(LakalaConstant.LAKALA_TRADE_RESPONSE_BIZ_KEY),
                    LakalaActivityPackageQueryResponse.class
            );
            response.setRespDataList(list);
            return response;
        } else {
            // 业务响应结果
            LakalaBizResponse bizResData = (LakalaBizResponse) resJson.getObject(LakalaConstant.LAKALA_TRADE_RESPONSE_BIZ_KEY, tradeApiDefinitionEnum.getResponseClass());
            resJson.remove(LakalaConstant.LAKALA_TRADE_RESPONSE_BIZ_KEY);

            // 完整响应结果
            LakalaBaseActivityResponse response = resJson.toJavaObject(LakalaBaseActivityResponse.class);
            response.setRespData(bizResData);
            return response;
        }
    }
}