/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiClient;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.LakalaHttpResult;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.DefaultHttpRequestImpl;
import com.fshows.lakala.client.impl.DefaultSignerImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseResponse;
import com.fshows.lakala.util.LogUtil;
import com.fshows.lakala.util.ValidateUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLakalaApiClientImpl<T extends LakalaBaseRequest, R extends LakalaBaseResponse>
implements ILakalaApiClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractLakalaApiClientImpl.class);
    protected ApiClientConfig apiClientConfig;
    protected IHttpRequest httpRequest;
    protected ISigner signer;

    public AbstractLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = new DefaultHttpRequestImpl();
        this.signer = new DefaultSignerImpl();
    }

    public AbstractLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = httpRequest;
        this.signer = signer;
    }

    protected R doExecute(LakalaBizRequest bizRequest, ILakalaApiDefinition tradeApiDefinitionEnum) throws LakalaApiException {
        try {
            boolean bo;
            this.checkParam(bizRequest, tradeApiDefinitionEnum);
            T lakalaBaseRequest = this.buildLakalaBizRequest(bizRequest, tradeApiDefinitionEnum);
            String body = this.serializableRequest(lakalaBaseRequest, tradeApiDefinitionEnum);
            SignParam signParam = this.buildSignParam(lakalaBaseRequest, body);
            String authorization = this.signer.sign(signParam, this.apiClientConfig);
            String url = this.getServerURL(tradeApiDefinitionEnum);
            LakalaHttpResult httpResult = this.requestPost(url, authorization, signParam.getBody());
            if (this.apiClientConfig.isVrifySignResponse() && !(bo = this.signer.verifySign(httpResult.getBody(), httpResult.getVerifySignParam(), this.apiClientConfig).booleanValue())) {
                LogUtil.error(log, "\u3010lakala-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> httpResult={}", httpResult);
                throw new LakalaApiException("[lakala-sdk]\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
            }
            return this.parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
        }
        catch (LakalaApiException e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new LakalaApiException(e.getMessage(), e);
        }
    }

    protected LakalaHttpResult requestPost(String url, String authorization, String requestBody) throws IOException, LakalaApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}, authorization={}, request={}, begin={}", url, authorization, requestBody, beginTime);
            LakalaHttpResult httpResult = this.httpRequest.post(url, authorization, requestBody, this.apiClientConfig);
            if (httpResult == null) {
                throw new LakalaApiException("lakala\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, response={}, lakalaTraceId={}, cost={}ms", url, requestBody, httpResult.getBody(), httpResult.getLakalaTraceId(), System.currentTimeMillis() - beginTime);
            return httpResult;
        }
        catch (LakalaApiException e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw new LakalaApiException("\u8bf7\u6c42lakala\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    protected void checkParam(LakalaBizRequest bizRequest, ILakalaApiDefinition lakalaApiDefinition) throws LakalaApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)lakalaApiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new LakalaApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected String getServerURL(ILakalaApiDefinition tradeApiDefinitionEnum) {
        return this.apiClientConfig.getApiParentURL() + tradeApiDefinitionEnum.getApiSubURI();
    }

    protected abstract T buildLakalaBizRequest(LakalaBizRequest var1, ILakalaApiDefinition var2);

    protected abstract SignParam buildSignParam(T var1, String var2);

    protected abstract String serializableRequest(T var1, ILakalaApiDefinition var2);

    protected abstract R parseResponse(String var1, ILakalaApiDefinition var2);

    public void setApiClientConfig(ApiClientConfig apiClientConfig) {
        this.apiClientConfig = apiClientConfig;
    }

    public void setHttpRequest(IHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setSigner(ISigner signer) {
        this.signer = signer;
    }
}

