/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 拆单信息
 * 如果查询订单是主单，则返回。见splitInfo字段说明。拆单信息见split_info域说明
 *
 * @author liluqing
 * @version LakalaOrderSplitInfoResponse.java, v 0.1 2022-03-07 14:11
 */
@Data
public class LakalaOrderSplitInfoResponse implements Serializable {

    private static final long serialVersionUID = -1410869934802293417L;
    /**
     * 子单交易流水号 (必填参数)
     * 子单交易流水号
     */
    @NotBlank
    @Length(max = 32, message = "子单交易流水号长度不能超过32")
    private String subTradeNo;

    /**
     * 子单对账单流水号 (必填参数)
     * 子单对账单流水号
     */
    @NotBlank
    @Length(max = 14, message = "子单对账单流水号长度不能超过14")
    private String subLogNo;

    /**
     * 外部子交易流水号 (必填参数)
     * 商户子交易流水号，商户号下唯一
     */
    @NotBlank
    @Length(max = 32, message = "外部子交易流水号长度不能超过32")
    private String outSubTradeNo;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 商户名称 (必填参数)
     * 商户名称
     */
    @NotBlank
    @Length(max = 64, message = "商户名称长度不能超过64")
    private String merchantName;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的业务终端号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 金额 (必填参数)
     * 单位分，整数型字符
     */
    @NotBlank
    @Length(max = 12, message = "金额长度不能超过12")
    private String amount;

}