/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.union;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 银联云闪付主扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version UnionPreOrderAccBusiRequest.java, v 0.1 2022-03-07 11:56
 */
@Data
public class UnionPreOrderAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = 4541459199873294445L;
    /**
     * 用户id (必填参数)
     */
    @NotBlank
    @Length(max = 64, message = "用户id长度不能超过64")
    private String userId;

    /**
     * 预下单有效时间 (选填)
     * 预下单的订单的有效时间，以分钟为单位。如果在有效时间内没有完成付款，则在账户端该订单失效。如果不上送，以账户端订单失效时间为准。 建议不超过15分钟。不传值则默认5分钟。
     */
    @Length(max = 2, message = "预下单有效时间长度不能超过2")
    private String timeoutExpress;

    /**
     * 银联订单信息(暂不支持) (选填)
     * 银联单品营销订单信息
     */
    @Length(max = 600, message = "银联订单信息(暂不支持)长度不能超过600")
    private String acqAddnDataOrderInfo;

    /**
     * 银联商品信息(暂不支持) (选填)
     * 银联单品营销商品信息
     */
    @Length(max = 6000, message = "银联商品信息(暂不支持)长度不能超过6000")
    private String acqAddnDataGoodsInfo;

    /**
     * 银联前台通知地址 (选填)
     * 收款方向银联推送订单时上送的前台通知地址（仅允许为外网地址），用户完成支付点击，“返回”后，银联通过浏览器POST请求到该地址。 当transType为JSAPI，payMode为UQRCODEPAY时，可选填此字段
     */
    @Length(max = 256, message = "银联前台通知地址长度不能超过256")
    private String frontUrl;

    /**
     * 银联失败交易前台通知地址 (选填)
     * 收款方向银联推送订单时上送的失败交易前台通知地址（仅允许为外网地址），用户支付过程中交易失败，点击“返回”后，银联通过浏览器GET请求到该地址。 当transType为JSAPI，payMode为UQRCODEPAY时，可选填此字段，需与frontUrl同时出现，未上送默认为frontUrl的值
     */
    @Length(max = 256, message = "银联失败交易前台通知地址长度不能超过256")
    private String frontFailUrl;
}