/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaWechatConfigResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version LakalaWechatConfigRequest.java, v 0.1 2023-02-16 15:56 zhubo
 */
@Data
public class LakalaWechatConfigRequest extends LakalaBizRequest<LakalaWechatConfigResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 2340011146704527507L;

    /**
     * 银联商户号
     */
    @NotBlank
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 微信渠道号 （仅支持拉卡拉渠道配置）
     */
    @NotBlank
    @Length(max = 32, message = "微信渠道号长度不能超过32")
    private String channlId;

    /**
     * 微信子商户号
     */
    @NotBlank
    @Length(max = 32, message = "微信子商户号长度不能超过32")
    private String subMchId;

    /**
     * 推荐关注APPID
     */
    @Length(max = 32, message = "推荐关注APPID长度不能超过32")
    private String subscribeAppid;

    /**
     * 关联APPID 绑定特约商户或渠道公众号、小程序、APP支付等对应的APPID
     */
    @Length(max = 32, message = "关联APPID长度不能超过32")
    private String subAppid;

    /**
     * 授权目录
     */
    @Length(max = 64, message = "授权目录长度不能超过64")
    private String jsapiPath;

    /**
     * 配置类型
     * 类型=SUB_APPID时，subAppid必传
     * 类型=SUBSCRIBE_APPID时，subscribeAppid必传
     * 类型=UNION时，subAppid和subscribeAppid必传
     * 类型=JSAPI_PATH时，jsapiPath必传
     */
    @NotBlank
    @Length(max = 64, message = "配置类型长度不能超过64")
    private String confType;
}
