/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.lakala.enums.merchant.LakalaMerchantResponseCodeEnum;
import com.fshows.lakala.enums.trade.LakalaTradeResponseCodeEnum;
import lombok.Data;

import java.util.List;

/**
 * @author zhaoxumin
 * @version EcLakalaApiClientImpl.java, v 0.1 2025-09-12 14:36 zhaoxumin
 */
@Data
public class LakalaBaseEcResponse<E extends LakalaBizResponse> extends LakalaBaseResponse {

    private static final long serialVersionUID = -315829916861850728L;
    /**
     * 返回业务代码
     */
    private String code;

    /**
     * 返回业务代码描述
     */
    private String msg;

    /**
     * 响应时间,格式yyyyMMddHHmmss
     */
    private String respTime;

    /**
     * 响应数据
     */
    private E respData;

    /**
     * 响应数据列表
     */
    private List<E> respDataList;

    @JSONField(serialize = false)
    @Override
    public boolean isSuccess() {
        return LakalaMerchantResponseCodeEnum.SUCCESS.getValue().equals(this.getCode());
    }
}