/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.enums.other.LakalaOtherApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaSsoLoginResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version LakalaSsoLoginRequest.java, v 0.1 2025-07-29 15:28 zhangling
 */
@Data
@JsonNaming(PropertyNamingStrategies.SnakeCaseStrategy.class)
public class LakalaSsoLoginRequest extends LakalaBizRequest<LakalaSsoLoginResponse, LakalaOtherApiDefinitionEnum> {

    /**
     * 商户编号
     */
    @NotBlank(message = "商户编号不能为空")
    @JSONField(name = "merchant_no")
    private String merchantNo;

    /**
     * 通道
     * 00(商服收银台)02(收单宝)03(商户通通用-数币H5)04(发票H5)05(商服对账单)06(员工管理)07(签购单)
     */
    @JSONField(name = "channel")
    @NotBlank(message = "通道不能为空")
    private String channel;

    /**
     * 商户名称
     */
    @JSONField(name = "merchant_name")
    private String merchantName;

    /**
     * 交易流水号;channel=07时需要(待生效)
     */
    @JSONField(name = "log_no")
    private String logNo;
}