/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaEcApplyManualResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zhaoxumin
 * @version LakalaEcApplyManualRequest.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcApplyManualRequest extends LakalaBizRequest<LakalaEcApplyManualResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 4554628376432699569L;
    /**
     * 四方机构自定义订单编号 (必填参数)
     * 建议：平台编号+14位年月日时（24小时制）分秒+8位的随机数（同一接入机构不重复）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构号 (必填参数)
     */
    @NotNull(message = "机构号不能为空")
    private Integer orgId;

    /**
     * 电子签约申请受理编号
     */
    @NotNull
    private Long ecApplyId;

    /**
     * 复议提交的原因说明
     */
    @NotBlank
    private String applyDesc;

    /**
     * 提供给审核人员核对信息；附件类型：营业执照（申请信息中执照字段有填写，则必传执照图片，无执照信息可以不传执照图片）、身份证正,反面、银行卡
     */
    @NotBlank
    @Length(max = 32, message = "证件号码长度不能超过32")
    private List<LakalaEcAttachInfoRequest> fileData;
}