/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.response.trade.info;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangyi
 * @version LakalaBankPayOrderInfoResponse.java, v 0.1 2023-08-28 18:51 wangyi
 */
@Data
public class LakalaBankPayOrderInfoResponse implements Serializable {

    private static final long serialVersionUID = -1827592429649462858L;

    /**
     * 交易流水号 (必传参数)
     */
    private String tradeNo;

    /**
     * 对账单流水号 (必传参数)
     */
    private String logNo;

    /**
     * 交易参考号 (必传参数, 仅busi_type为UPCARD时返回)
     */
    private String tradeRefNo;

    /**
     * 交易类型 (必传参数)
     */
    private String tradeType;

    /**
     * 支付状态 (必传参数)
     */
    private String tradeStatus;

    /**
     * 交易金额，单位：分 (必传参数)
     */
    private long tradeAmount;

    /**
     * 付款人实际支付金额，单位：分 (必传参数)
     */
    private long payerAmount;

    /**
     * 用户标识1 (可选参数)
     */
    private String userId1;

    /**
     * 用户标识2 (可选参数)
     */
    private String userId2;

    /**
     * 支付业务类型 (必传参数)
     */
    private String busiType;

    /**
     * 交易完成时间 (可选参数)
     */
    private String tradeTime;

    /**
     * 付款受理交易流水号 (可选参数)
     */
    private String accTradeNo;

    /**
     * 付款人账号 (可选参数)
     */
    private String payerAccountNo;

    /**
     * 付款人名称（仅ONLINE交易返回） (可选参数)
     */
    private String payerName;

    /**
     * 付款账号开户行 (可选参数)
     */
    private String payerAccountBank;

    /**
     * 账户类型 (可选参数)
     */
    private String accType;

    /**
     * 付款方式 (可选参数)
     */
    private String payMode;

    /**
     * 终端批次号 (可选参数)
     */
    private String clientBatchNo;

    /**
     * 终端流水号 (可选参数)
     */
    private String clientSeqNo;

    /**
     * 结算商户号 (可选参数)
     */
    private String settleMerchantNo;

    /**
     * 结算终端号 (可选参数)
     */
    private String settleTermNo;

    /**
     * 原交易流水号 (可选参数)
     */
    private String originTradeNo;

    /**
     * 交易备注 (可选参数)
     */
    private String tradeRemark;
}