/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.response.merchant;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhaoxumin
 * @version LakalaEcQueryApplyManualStatusResponse.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcQueryApplyManualStatusResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 4569760759964976184L;
    /**
     * 四方机构自定义订单编号 (必填参数)
     * 订单编号与请求时的 orderNo 保持一致
     */
    private String orderNo;

    /**
     * 机构号 (必填参数)
     * 签约方所属拉卡拉机构
     */
    private Integer orgId;

    /**
     * 电子合同申请受理号 (必填参数)
     * 申请接口反馈编号
     */
    private Long ecApplyId;

    /**
     * 人工审核状态 (必填参数)
     * 审核状态的值为 WAIT_AUDIT、PASS、REFUSE、CLOSE
     */
    private String auditStatus;

    /**
     * 人工审核结果说明
     * 针对审核状态的说明
     */
    private String auditDesc;

    /**
     * 签约H5地址 (审核通过时返回)
     */
    private String signH5Url;

    /**
     * 签约H5地址过期时间 (审核通过时返回)
     */
    private String signH5UrlExpTm;
}