/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaAddMerchantResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户进价复议
 *
 * @author linzy
 * @version LakalaReconsiderSubmitRequest.java, v 0.1 2022-06-06 15:48
 */
@Data
public class LakalaReconsiderSubmitRequest extends LakalaBizRequest<LakalaAddMerchantResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = -1814856077659924194L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文） (必填参数)
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;
    /**
     * 机构代码
     */
    private String orgCode;

    /**
     * 进件ID
     */
    private String contractId;
}