/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
/**
 * @author zhaoxumin
 * @version LakalaEcAttachInfoRequest.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@Data
public class LakalaEcAttachInfoRequest {

    private static final long serialVersionUID = -2756453978345151666L;
    /**
     * 附件类型 (必填参数)
     * https://o.lakala.com/#/home/document/detail?id=981
     */
    @NotBlank
    private String attachType;

    /**
     * 附件名称 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "附件名称不能超过32")
    private String attachName;

    /**
     * 附件格式 (必填参数). jpg、pdf
     */
    @NotBlank
    private String attachExtName;

    /**
     * 附件坐标URL (必填参数)
     */
    @NotBlank
    private String attachStorePath;
}