/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 拉卡拉请求基类
 *
 * @author liluqing
 * @version LakalaBaseRequest.java, v 0.1 2022-03-02 11:20
 */
@Data
public class LakalaBaseOtherRequest<E extends LakalaBizRequest> extends LakalaBaseRequest {

    private static final long serialVersionUID = 1966195687416188714L;

    /**
     * Unix时间戳(毫秒)，13位
     */
    private Long timestamp;

    /**
     * 随机数
     */
    private String rnd;

    /**
     * 版本号
     */
    private String ver;

    /**
     * 版本号
     */
    private String reqId;

    /**
     * 业务请求参数
     */
    @JSONField(name = "req_data")
    private E reqData;
}