/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.response.merchant;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhaoxumin
 * @version LakalaEcApplyResponse.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcApplyResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -723613762982753668L;
    /**
     * 请求上送的订单号
     */
    private String orderNo;

    /**
     * 电子签约申请受理编号
     */
    private Long ecApplyId;

    /**
     * 电子签约申请结果H5链接地址(长度较长2000+)
     *  申请成功时：待签约合同H5链接
     *  申请失败时：错误信息结果H5链接
     */
    private String resultUrl;
}