/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.response.merchant;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhaoxumin
 * @version LakalaEcDownloadResponse.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcDownloadResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -7804275287758839244L;
    /**
     * 请求上送的订单号 (必填参数)
     */
    private String orderNo;

    /**
     * 电子签约申请受理编号 (必填参数)
     */
    private Long ecApplyId;

    /**
     * 电子合同状态 (必填参数)
     * UNDONE: 未完成
     * COMPLETED: 已完成
     */
    private String ecStatus;

    /**
     * 电子合同号 (可选，电子合同状态为COMPLETED时返回)
     */
    private String ecNo;

    /**
     * 电子合同pdf文件 电子合同状态为COMPLETED时返回；
     *
     * 服务端 :
     * 使用spring框架Base64Utils.encodeToUrlSafeString方法转base64格式字符
     * 客户端:
     * 使用spring框架Base64Utils.decodeFromUrlSafeString 方法获取文件字节保存
     */
    private String ecFile;
}