/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaSettleQueryAcctInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户账户余额查询请求
 *
 * @author liluqing
 * @version LakalaSettleQueryAcctInfoRequest.java, v 0.1 2022-03-08 10:22
 */
@Data
public class LakalaSettleQueryAcctInfoRequest extends LakalaBizRequest<LakalaSettleQueryAcctInfoResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = 7160324677427166072L;

    /**
     * 查询流水 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "查询流水长度不能超过32")
    private String qryNo;

    /**
     * 商户号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merId;

    /**
     * 余额查询标识 (必填参数)
     * 1-联机余额<br>2-数字货币余额<br>3-暂缓结算余额<br>4-退货账户余额
     */
    @NotBlank
    @Length(max = 32, message = "余额查询标识长度不能超过32")
    private String balanceFlag;

    /**
     * 备用自段 (选填)
     */
    @Length(max = 32, message = "备用自段长度不能超过32")
    private String resv1;

}