/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.saas;

import com.fshows.lakala.enums.saas.LakalaSaasApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.saas.LakalaWxAndUnionUserIdResponse;
import lombok.Data;

/**
 * 微信openid查询&银联userid查询
 *
 * @author liluqing
 * @version LakalaWxAndUnionUserIdRequest.java, v 0.1 2023-02-17 16:37
 */
@Data
public class LakalaWxAndUnionUserIdRequest extends LakalaBizRequest<LakalaWxAndUnionUserIdResponse, LakalaSaasApiDefinitionEnum> {

    private static final long serialVersionUID = 3274925187788775366L;

    /**
     * 商户号
     */
    private String mercId;

    /**
     * 终端号
     */
    private String termNo;

    /**
     * 微信付款码
     */
    private String authCode;

    /**
     * 交易码
     * 微信：010304
     * 银联：030304
     */
    private String tradeCode;

    /**
     * 微信子商户公众号id
     */
    private String subAppid;

    /**
     * 银联支付标识,获取银联钱包userId时，必传
     */
    private String appUpIdentifier;
}