package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaWechatRealNameQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liangyuanping
 * @version LakalaWechatRealNameQueryRequest.java, v 0.1 2023-02-23 9:47 AM
 */
@Data
public class LakalaWechatRealNameQueryRequest extends LakalaBizRequest<LakalaWechatRealNameQueryResponse, LakalaMerchantApiDefinitionEnum> {

    /**
     * 接口版本号 (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 拉卡拉内部商户号
     */
    @Length(max = 32, message = "拉卡拉内部商户号长度不能超过32")
    private String merInnerNo;

    /**
     * 子商户号
     */
    @Length(max = 64, message = "子商户号长度不能超过64")
    private String subMchId;
    /**
     * 渠道号（建议传入，能具体定位用的渠道，仅支持拉卡拉渠道查询）
     */
    private String channelId;
    /**
     * 实名认证类型
     * WXZF:微信
     */
    private String realNameType;
}