/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author mengqf
 * @version LakalaForeignCardFeeRequest.java, v 0.1 2025-05-14 13:46 mengqf
 */
@Data
public class LakalaForeignCardFeeRequest implements Serializable {
    private static final long serialVersionUID = -7498652654189485626L;
    /**
     * 外卡费率类别
     * 190 VISA
     * 191 MASTER
     * 192 JCB
     * 193 AMEX
     * 194 DINER
     */
    @NotBlank
    private String feeRateKind;

    /**
     * 手续费率(%) (必填参数)
     * 0.6
     */
    @NotBlank
    private String feeRatePct;

    /**
     * 单笔交易手续费封顶 (选填)
     * 默认不封顶，单位（元）
     */
    private String feeUpperAmtPcnt;

    /**
     * 费率类型 (必填参数)
     * 200 EDC
     * 201 DCC （只有 190 191 外卡费率类别支持）
     */
    @NotBlank
    private String feeRateTypeCode;

    /**
     * 手续费生效日期 (选填)
     * 默认为进件日期
     */
    private String feeRateStDt;
}