package com.fshows.lakala.enums.other;

import org.apache.commons.lang3.StringUtils;

/**
 * 拉卡拉商户服务API响应码枚举
 *
 * @author liluqing
 * @version LakalaMerchantResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum LakalaOthetResponseCodeEnum {
    SUCCESS("成功", "000000")

    ;

    private String name;
    private String value;

    LakalaOthetResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static LakalaOthetResponseCodeEnum getByValue(String value) {
        LakalaOthetResponseCodeEnum[] valueList = LakalaOthetResponseCodeEnum.values();
        for (LakalaOthetResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}