/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseOtherRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseOtherResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.ReqIdUtil;

public class OtherLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseOtherRequest, LakalaBaseOtherResponse> {
    private static SerializeConfig serializeConfig = new SerializeConfig();

    public OtherLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public OtherLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseOtherResponse<T> execute(LakalaBizRequest<T, R> request, R merchantApiDefinitionEnum) throws LakalaApiException {
        return (LakalaBaseOtherResponse)super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseOtherRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        LakalaBaseOtherRequest<LakalaBizRequest> request = new LakalaBaseOtherRequest<LakalaBizRequest>();
        request.setTimestamp(System.currentTimeMillis());
        request.setRnd(RandomUtil.randomString((int)12));
        request.setVer(merchantApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseOtherRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseOtherRequest lakalaBaseRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseOtherResponse parseResponse(String resBody, ILakalaApiDefinition merchantApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("resp_data", merchantApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"resp_data");
        LakalaBaseOtherResponse response = (LakalaBaseOtherResponse)resJson.toJavaObject(LakalaBaseOtherResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        OtherLakalaApiClientImpl.serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
    }
}

