/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 *
 * @author liluqing
 * @version LakalaTermDataRequest.java, v 0.1 2023-08-14 17:06
 */
@Data
public class LakalaTermDataRequest {

    /**
     * 网点ID (选填)
     */
    @Length(max = 32, message = "网点ID长度不能超过32")
    private String shopId;

    /**
     * 终端数量（1-5） 最大5个终端 (必填参数)
     * 1
     */
    @NotBlank
    @Length(max = 8, message = "终端数量（1-5） 最大5个终端长度不能超过8")
    private String termNum;

    /**
     * 终端号 (选填)
     */
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 终端设备序列号 (选填)
     */
    @Length(max = 64, message = "终端设备序列号长度不能超过64")
    private String devSerialNo;

    /**
     * 设备型号 (选填)
     */
    @Length(max = 32, message = "设备型号长度不能超过32")
    private String devTypeName;

    /**
     * 终端版本号 (选填)
     */
    @Length(max = 32, message = "终端版本号长度不能超过32")
    private String termVer;
}