/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 费率信息集合
 *
 * @author liluqing
 * @version LakalaFeeRateRequest.java, v 0.1 2022-03-08 15:53
 */
@Data
public class LakalaFeeRateRequest implements Serializable {

    private static final long serialVersionUID = 7598421251017653860L;

    /**
     * 费率类型 (必填参数)
     * 参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhuempff172" target="_blank" title="费率类型字典表">费率类型字典表</a>】
     */
    @NotBlank
    private String feeRateTypeCode;

    /**
     * 费率类型名称 (必填参数)
     * 银行卡借记卡
     */
    @NotBlank
    private String feeRateTypeName;

    /**
     * 手续费率(%) (必填参数)
     * 0.6
     */
    @NotBlank
    private String feeRatePct;

    /**
     * 单笔交易手续费封顶 (选填)
     * 默认不封顶，单位（元）
     */
    private String feeUpperAmtPcnt;

    /**
     * 单笔交易手续费保低 (选填)
     * 默认无保底，单位（元）
     */
    private String feeLowerAmtPcnt;

    /**
     * 手续费生效日期 (选填)
     * 默认为进件日期
     */
    private String feeRateStDt;

}