/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.lakala.client.base;

import com.fshows.lakala.exception.LakalaApiException;

/**
 * @author liluqing
 * @version Signer.java, v 0.1 2022-03-02 7:51 PM liluqing
 */
public interface ISigner {

    /**
     * 加签
     *
     * @param signParam       签名参数
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws LakalaApiException;

    /**
     * 验签
     *
     * @param sign            签名值
     * @param signParam       签名参数
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    Boolean verifySign(String body, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws LakalaApiException;
}
