/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 地址信息
 *
 * @author liluqing
 * @version LakalaLocationInfoRequest.java, v 0.1 2022-03-07 11:12
 */
@Data
public class LakalaLocationInfoRequest implements Serializable {

    private static final long serialVersionUID = -5190553046593646539L;
    /**
     * 请求方IP地址 (必填参数)
     * 请求方的IP地址，存在必填，格式如36.45.36.95
     */
    @NotBlank
    @Length(max = 64, message = "请求方IP地址长度不能超过64")
    private String requestIp;

    /**
     * 基站信息 (选填)
     * 客户端设备的基站信息（主扫时基站信息使用该字段）
     */
    @Length(max = 128, message = "基站信息长度不能超过128")
    private String baseStation;

    /**
     * 维度,经度 (选填)
     * 商户终端的地理位置，存在必填 格式：纬度,经度，+表示北纬、东经，-表示南纬、 西经，精度最长支持小数点后9位。举例:+37.123456789,-121.123456789
     */
    @Length(max = 32, message = "维度,经度长度不能超过32")
    private String location;
}