/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.trade.order.LakalaOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 订单查询接口
 *
 * @author liluqing
 * @version LakalaOrderQueryRequest.java, v 0.1 2022-03-04 17:22
 */
@Data
public class LakalaOrderQueryRequest extends LakalaBizRequest<LakalaOrderQueryResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 2678139147361546344L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 商户交易流水号 (选填)
     * 下单时的商户请求流水号 说明：out_trade_no、trade_no、必有其一。如果存在多个字段上送，优先级顺序如下： trade_no、 out_trade_no
     */
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 拉卡拉交易流水号 (选填)
     * 拉卡拉交易流水号
     */
    @Length(max = 32, message = "拉卡拉交易流水号长度不能超过32")
    private String tradeNo;

}