/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaQueryContractResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version LakalaQueryContractRequest.java, v 0.1 2023-02-16 15:26 zhubo
 */
@Data
public class LakalaQueryContractRequest extends LakalaBizRequest<LakalaQueryContractResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = -7776440610017653830L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 （便于后续跟踪排查问题及核对报文）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码
     */
    @NotBlank
    @Length(max = 32, message = "机构进件代码长度不能超过32")
    private String orgCode;

    /**
     * 进件ID
     */
    @NotBlank
    @Length(max = 32, message = "进件ID长度不能超过32")
    private String contractId;
}
