/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.response.trade.accbusifields.LakalaOrderQueryAccBusiResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 订单查询响应结果
 *
 * @author liluqing
 * @version LakalaOrderQueryResponse.java, v 0.1 2022-03-04 17:23
 */
@Data
public class LakalaOrderQueryResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -736329689651040494L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号（请求接口中商户号）
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 商户请求流水号 (必填参数)
     * 请求中的商户请求流水号
     */
    @NotBlank
    @Length(max = 32, message = "商户请求流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 拉卡拉商户订单号 (必填参数)
     * 拉卡拉生成的交易流水
     */
    @NotBlank
    @Length(max = 32, message = "拉卡拉商户订单号长度不能超过32")
    private String tradeNo;

    /**
     * 拉卡拉对账单流水号 (必填参数)
     * trade_no的后14位
     */
    @NotBlank
    @Length(max = 14, message = "拉卡拉对账单流水号长度不能超过14")
    private String logNo;

    /**
     * 交易大类 (选填)
     * PREORDER-主扫，MICROPAY-被扫，REFUND-退款，CANCEL-撤销，无-其它类型
     */
    @Length(max = 32, message = "交易大类长度不能超过32")
    private String tradeMainType;

    /**
     * 拆单属性 (选填)
     * 只有涉及合单交易时会出现：M-主单，S-子单
     */
    @Length(max = 1, message = "拆单属性长度不能超过1")
    private String splitAttr;

    /**
     * 拆单信息 (选填)
     * 如果查询订单是主单，则返回。见splitInfo字段说明。拆单信息见split_info域说明
     */
    private LakalaOrderSplitInfoResponse splitInfo;

    /**
     * 账户端交易订单号 (必填参数)
     * 账户端交易流水号
     */
    @NotBlank
    @Length(max = 32, message = "账户端交易订单号长度不能超过32")
    private String accTradeNo;

    /**
     * 钱包类型 (必填参数)
     * 微信：WECHAT 支付宝：ALIPAY 银联：UQRCODEPAY 翼支付: BESTPAY 苏宁易付宝: SUNING
     */
    @NotBlank
    @Length(max = 32, message = "钱包类型长度不能超过32")
    private String accountType;

    /**
     * 交易状态 (必填参数)
     * INIT-初始化 CREATE-下单成功 SUCCESS-交易成功 FAIL-交易失败 DEAL-交易处理中 UNKNOWN-未知状态 CLOSE-订单关闭 PART_REFUND-部分退款 REFUND-全部退款 REVOKED-订单撤销
     */
    @NotBlank
    @Length(max = 16, message = "交易状态长度不能超过16")
    private String tradeState;

    /**
     * 交易状态描述 (选填)
     * 交易状态描述
     */
    @Length(max = 256, message = "交易状态描述长度不能超过256")
    private String tradeStateDesc;

    /**
     * 订单金额 (必填参数)
     * 单位分，整数数字型字符
     */
    @NotBlank
    @Length(max = 12, message = "订单金额长度不能超过12")
    private String totalAmount;

    /**
     * 付款人实付金额 (选填)
     * 付款人实付金额，单位分
     */
    @Length(max = 12, message = "付款人实付金额长度不能超过12")
    private String payerAmount;

    /**
     * 账户端结算金额 (选填)
     * 账户端应结订单金额，单位分
     */
    @Length(max = 12, message = "账户端结算金额长度不能超过12")
    private String accSettleAmount;

    /**
     * 商户侧优惠金额（账户端） (选填)
     * 商户优惠金额，单位分
     */
    @Length(max = 12, message = "商户侧优惠金额（账户端）长度不能超过12")
    private String accMdiscountAmount;

    /**
     * 账户端优惠金额 (选填)
     * 拉卡拉优惠金额，单位分
     */
    @Length(max = 12, message = "账户端优惠金额长度不能超过12")
    private String accDiscountAmount;

    /**
     * 交易完成时间 (选填)
     * 实际支付时间。yyyyMMddHHmmss
     */
    @Length(max = 14, message = "交易完成时间长度不能超过14")
    private String tradeTime;

    /**
     * 用户标识1 (选填)
     * 微信sub_open_id 支付宝buyer_logon_id（买家支付宝账号）
     */
    @Length(max = 128, message = "用户标识1长度不能超过128")
    private String userId1;

    /**
     * 用户标识2 (选填)
     * 微信openId支 付宝buyer_user_id 银联user_id
     */
    @Length(max = 128, message = "用户标识2长度不能超过128")
    private String userId2;

    /**
     * 付款银行 (选填)
     * 付款银行
     */
    @Length(max = 128, message = "付款银行长度不能超过128")
    private String bankType;

    /**
     * 银行卡类型 (选填)
     * 00：借记 01：贷记 02：微信零钱 03：支付宝花呗 04：支付宝其他 05：数字货币 06：拉卡拉支付账户 99：未知
     */
    @Length(max = 16, message = "银行卡类型长度不能超过16")
    private String cardType;

    /**
     * 活动 ID (选填)
     * 在账户端商户后台配置的批次 ID
     */
    @Length(max = 32, message = "活动 ID长度不能超过32")
    private String accActivityId;

    /**
     * 账户端返回信息域 (选填)
     * 账户端返回信息域
     */
    private LakalaOrderQueryAccBusiResponse accRespFields;
}