/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaChangeMerchantResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Set;

/**
 * 商户进件
 *
 * @author liluqing
 * @version LakalaChangeMerchantRequest.java, v 0.1 2022-03-08 15:48
 */
@Data
public class LakalaChangeMerchantRequest extends LakalaBizRequest<LakalaChangeMerchantResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 8441206421249264084L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文） (必填参数)
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank
    @Length(max = 32, message = "订单编号（便于后续跟踪排查问题及核对报文）长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准) (必填参数)
     * 4002019111800000020
     */
    @Length(max = 32, message = "商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准)长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号 (必填参数)
     * 82229005411000A
     */
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 商户注册名称 (选填)
     */
    @Length(max = 64, message = "商户注册名称长度不能超过64")
    private String merRegName;

    /**
     * 商户经营名称 (选填)
     */
    @Length(max = 64, message = "商户经营名称长度不能超过64")
    private String merBizName;

    /**
     * 商户地区代码 (选填)
     * 地区代码，参看地区文档
     */
    @Length(max = 16, message = "商户地区代码长度不能超过16")
    private String merRegDistCode;

    /**
     * 商户详细地址 (选填)
     * 去除省，市，区后的详细地址
     */
    @Length(max = 128, message = "商户详细地址长度不能超过128")
    private String merRegAddr;

    /**
     * 商户MCC编号 (选填)
     * 银联商户类别代码
     */
    @Length(max = 8, message = "商户MCC编号长度不能超过8")
    private String mccCode;

    /**
     * 营业执照名称 (选填)
     */
    @Length(max = 64, message = "营业执照名称长度不能超过64")
    private String merBlisName;

    /**
     * 营业执照号 (选填)
     */
    @Length(max = 32, message = "营业执照号长度不能超过32")
    private String merBlis;

    /**
     * 营业执照开始日期 (选填)
     * 格式（yyyy-MM-dd）
     */
    @Length(max = 10, message = "营业执照开始日期长度不能超过10")
    private String merBlisStDt;

    /**
     * 营业执照有效期 (选填)
     * 格式（yyyy-MM-dd）
     */
    @Length(max = 10, message = "营业执照有效期长度不能超过10")
    private String merBlisExpDt;

    /**
     * 商户经营内容 (选填)
     * 参看【经营内容字典表】文档
     */
    @Length(max = 32, message = "商户经营内容长度不能超过32")
    private String merBusiContent;

    /**
     * 商户法人姓名 (选填)
     */
    @Length(max = 32, message = "商户法人姓名长度不能超过32")
    private String larName;

    /**
     * 法人证件号码 (选填)
     */
    @Length(max = 32, message = "法人证件号码长度不能超过32")
    private String larIdcard;

    /**
     * 法人证件类型 (选填)
     */
    @Length(max = 32, message = "法人证件类型长度不能超过32")
    private String larIdType;

    /**
     * 法人证件开始日期 yyyy-MM-dd (选填)
     */
    @Length(max = 10, message = "法人证件开始日期 yyyy-MM-dd长度不能超过10")
    private String larIdcardStDt;

    /**
     * 法人证件有效期 yyyy-MM-dd (选填)
     */
    @Length(max = 10, message = "法人证件有效期 yyyy-MM-dd长度不能超过10")
    private String larIdcardExpDt;

    /**
     * 商户联系人手机号码 (选填)
     */
    @Length(max = 32, message = "商户联系人手机号码长度不能超过32")
    private String merContactMobile;

    /**
     * 商户联系人 (选填)
     */
    @Length(max = 32, message = "商户联系人长度不能超过32")
    private String merContactName;

    /**
     * 附件数据 (选填)
     * 参看下方【附件信息集合】
     */
    private Set<LakalaFileDataRequest> fileData;

    /**
     * 终端号 (选填)
     */
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 网点名称 (选填)
     * 终端号为空时，忽略此项变更
     */
    @Length(max = 80, message = "网点名称长度不能超过80")
    private String shopName;

    /**
     * 网点地址区划代码 (选填)
     * 终端号为空时，忽略此项变更
     */
    @Length(max = 8, message = "网点地址区划代码长度不能超过8")
    private String shopDistCode;

    /**
     * 网点详细地址 (选填)
     * 终端号为空时，忽略此项变更
     */
    @Length(max = 80, message = "网点详细地址长度不能超过80")
    private String shopAddr;

    /**
     * 网点联系人名称 (选填)
     * 终端号为空时，忽略此项变更
     */
    @Length(max = 32, message = "网点联系人名称长度不能超过32")
    private String shopContactName;

    /**
     * 网点联系人手机号 (选填)
     * 终端号为空时，忽略此项变更
     */
    @Length(max = 20, message = "网点联系人手机号长度不能超过20")
    private String shopContactMobile;

    /**
     * 结算账户开户行号 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 20, message = "结算账户开户行号长度不能超过20")
    private String openningBankCode;

    /**
     * 结算账户开户行名称 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 40, message = "结算账户开户行名称长度不能超过40")
    private String openningBankName;

    /**
     * 结算账户清算行号 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 20, message = "结算账户清算行号长度不能超过20")
    private String clearingBankCode;

    /**
     * 结算账户账号 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 40, message = "结算账户账号长度不能超过40")
    private String acctNo;

    /**
     * 结算账户名称 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 40, message = "结算账户名称长度不能超过40")
    private String acctName;

    /**
     * 结算账户性质 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 8, message = "结算账户性质长度不能超过8")
    private String acctTypeCode;

    /**
     * 结算周期 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 8, message = "结算周期长度不能超过8")
    private String settlePeriod;

    /**
     * 日切时间 (选填)
     * 参考【日切时间字典表】文档
     */
    @Length(max = 16, message = "日切时间长度不能超过16")
    private String clearDt;

    /**
     * 结算人证件类型 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 8, message = "结算人证件类型长度不能超过8")
    private String acctIdType;

    /**
     * 结算人证件号码 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 40, message = "结算人证件号码长度不能超过40")
    private String acctIdcard;

    /**
     * 结算人证件有效期 (选填)
     * 终端号为空时，变更商户层结算信息。
     */
    @Length(max = 10, message = "结算人证件有效期长度不能超过10")
    private String acctIdDt;

    /**
     * 回调地址 (必填参数)
     * url
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;

}