/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.common;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.common.ReplenishUploadFileResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version ReplenishUploadFileRequest.java, v 0.1 2023-05-15 13:50 zhubo
 */
@Data
public class ReplenishUploadFileRequest extends LakalaBizRequest<ReplenishUploadFileResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 7236226268131616785L;


    /**
     * 接口版本号 (必填参数)
     */
    @NotBlank
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    private String orgCode;

    /**
     * 进件ID
     */
    private String contractId;

    /**
     * 内部商户号
     */
    private String merInnerNo;

    /**
     * 银联商户号
     */
    private String merCupNo;

    /**
     * 附件类型 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "附件类型长度不能超过32")
    private String attType;

    /**
     * 附件扩展名称 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "附件扩展名称长度不能超过32")
    private String attExtName;

    /**
     * 附件内容 (必填参数)
     */
    @NotBlank
    private String attContext;
}