/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.constant;

/**
 *
 * @author liluqing
 * @version LakalaConstant.java, v 0.1 2022-03-04 15:57
 */
public class LakalaConstant {

    /**
     * 拉卡拉响应结果中业务响应结果的key
     */
    public static final String LAKALA_RESPONSE_BIZ_KEY = "respData";
    /**
     * 拉卡拉交易响应结果中业务响应结果的key
     */
    public static final String LAKALA_TRADE_RESPONSE_BIZ_KEY = "resp_data";

    /**
     * 拉卡拉待加签字符串格式
     * 具体格式： ${appid}\n${serialNo}\n${timeStamp}\n${nonceStr}\n${body}\n
     */
    public static final String LAKALA_WAIT_SIGN_FORMAT = "{}\n{}\n{}\n{}\n{}\n";

    /**
     * 拉卡拉授权字符串格式（即HTTP请求头中的Authorization字符串格式）
     * 格式：${Algorism}+空格+appid=“${appid}“,serial_no=“${serialNo}“,timestamp=“${timeStamp}“,nonce_str=“${nonceStr}“,signature=“${signature}“
     */
    public static final String LAKALA_AUTHORIZATION_FORMAT = "LKLAPI-{} appid=\"{}\",serial_no=\"{}\",timestamp=\"{}\",nonce_str=\"{}\",signature=\"{}\"";

    /**
     * 交易api版本
     */
    public final static String TRADE_API_VERSION_V3 = "3.0";

    /**
     * 商户api版本
     */
    public final static String MERCHANT_API_VERSION_V2 = "2.0";
    /**
     * 商户api版本
     */
    public final static String MERCHANT_API_VERSION_V1 = "1.0";

    /**
     * 结算api版本
     */
    public final static String SETTLE_API_VERSION_V1 = "1.0.0";

    /**
     * 结算api版本
     */
    public final static String SETTLE_API_VERSION_V2 = "1.0.0";

    /**
     * 拉卡拉http响应头--签名值
     */
    public final static String HTTP_RESPONSE_HEADER_SIGN = "Lklapi-Signature";

    /**
     * 拉卡拉http响应头--随机字符串
     */
    public final static String HTTP_RESPONSE_HEADER_NONCE = "Lklapi-Nonce";

    /**
     * 拉卡拉http响应头--时间戳
     */
    public final static String HTTP_RESPONSE_HEADER_TIMESTAMP = "Lklapi-Timestamp";

    /**
     * 拉卡拉http响应头--拉卡拉证书序列号
     */
    public final static String HTTP_RESPONSE_HEADER_SERIAL = "Lklapi-Serial";

    /**
     * 拉卡拉http响应头--拉卡拉证书序列号
     */
    public final static String HTTP_RESPONSE_HEADER_APPID = "Lklapi-Appid";

    /**
     * 拉卡拉http响应头--拉卡拉的traceId
     * 供研发查询定位问题使用，建议打印出来 异步交易结果通知无此字段
     */
    public final static String HTTP_RESPONSE_HEADER_TRACEID = "Lklapi-Traceid";
}