/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 退款响应参数
 *
 * @author liluqing
 * @version LakalaRefundResponse.java, v 0.1 2022-03-07 13:53
 */
@Data
public class LakalaRefundResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 5509752234158672929L;

    /**
    * 商户号
    */
    private String merchantNo;
    /**
     * 商户请求流水号 (必填参数)
     * 请求中的商户请求流水号
     */
    private String outTradeNo;

    /**
     * 拉卡拉退款单号 (必填参数)
     * 拉卡拉交易流水号
     */
    private String tradeNo;

    /**
     * 拉卡拉对账单流水号 (必填参数)
     * 拉卡拉对账单流水号
     */
    private String logNo;

    /**
     * 账户端交易订单号 (选填)
     * 账户端交易流水号
     */
    private String accTradeNo;

    /**
     * 钱包类型 (选填)
     * 微信：WECHAT 支付宝：ALIPAY 银联：UQRCODEPAY 翼支付: BESTPAY 苏宁易付宝: SUNING
     */
    private String accountType;

    /**
     * 交易金额 (必填参数)
     * 单位分，整数数字型字符串
     */
    private String totalAmount;

    /**
     * 申请退款金额 (必填参数)
     * 单位分，整数数字型字符串
     */
    private String refundAmount;

    /**
     * 实际退款金额 (必填参数)
     * 单位分，整数数字型字符串
     */
    private String payerAmount;

    /**
     * 退款时间 (选填)
     * 实际退款时间。yyyyMMddHHmmss
     */
    private String tradeTime;

    /**
     * 原拉卡拉订单号 (选填)
     * 如果请求中携带，则返回
     */
    private String originTradeNo;

    /**
     * 原商户请求流水号 (选填)
     * 如果请求中携带，则返回
     */
    private String originOutTradeNo;

    /**
     * 单品营销 附加数据 (选填)
     * 参与单品营销优惠时返回
     */
    private String upIssAddnData;

    /**
     * 银联优惠信息、出资方信息 (选填)
     * 参与单品营销优惠时返回
     */
    private String upCouponInfo;

    /**
     * 出资方信息 (选填)
     * 数字货币中行返回示例说明：[{“fundchannel”:”BOC”,”amount”:”18”}]
     */
    private String tradeInfo;

}