package com.fshows.lakala.response.activity;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

import java.util.Date;

/**
 * @author liangyuanping
 * @version LakalaApplyActiveSettleResponse.java, v 0.1 2023-02-15 2:52 PM
 */
@Data
public class LakalaActivityApplyQueryResponse extends LakalaBizResponse {

    /**
     * 活动银行
     */
    private String bank;
    /**
     * 银行logo
     */
    private String bankLogo;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 报名状态
     * 0:待审核,1:审核通过,2:审核拒绝,3:中断退出;4:取消申请
     */
    private String enrollStatus;
    /**
     * 起始时间
     */
    private Date startTime;
    /**
     * 起始时间字符串（yyyy-MM-dd HH:mm:ss）
     */
    private String startTimeStr;
    /**
     * 截止时间
     */
    private Date endTime;
    /**
     * 截止时间字符串（yyyy-MM-dd HH:mm:ss）
     */
    private String endTimeStr;
    /**
     * 活动地区（地区码）
     */
    private String region;
    /**
     * 活动描述
     */
    private String actDesc;
    /**
     * 活动扩展Json
     */
    private String extJson;
    /**
     * 报名审批意见
     */
    private String opinion;
}