/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.settle;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * 拉卡拉结算结果查询-分账明细
 *
 * @author liluqing
 * @version LakalaSettleResultQueryDataResponse.java, v 0.1 2022-03-08 10:08
 */
@Data
public class LakalaSettleResultQueryDataResponse implements Serializable {

    private static final long serialVersionUID = -3075923326650824594L;

    /**
     * 机构号 (选填)
     */
    @Length(max = 32, message = "机构号长度不能超过32")
    private String instId;

    /**
     * 分账请求流水id (选填)
     */
    @Length(max = 32, message = "分账请求流水id长度不能超过32")
    private String ledgerTranSid;

    /**
     * 状态 (选填)
     * 00：完成受理中 <br>01：完成失败<br>02：分账成功
     */
    @Length(max = 8, message = "状态长度不能超过8")
    private String txnStat;

    /**
     * 发起商户号 (选填)
     */
    @Length(max = 32, message = "发起商户号长度不能超过32")
    private String sendMerId;

    /**
     * 发起终端号 (选填)
     */
    @Length(max = 32, message = "发起终端号长度不能超过32")
    private String sendTermId;

    /**
     * 交易日期 (选填)
     * 20201106
     */
    @Length(max = 8, message = "交易日期长度不能超过8")
    private String tranDate;

    /**
     * 交易时间 (选填)
     * 132455
     */
    @Length(max = 6, message = "交易时间长度不能超过6")
    private String tranTime;

    /**
     * 完成接收商终list (选填)
     * 包含发起商户本身金额
     */
    private List<LakalaSettleResultQueryRevcDataResponse> revcData;

}