package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaTerminalActiveQueryResponse;
import lombok.Data;

/**
 * 设备解绑请求
 *
 * @author liangyuanping
 * @version LakalaWechatRealNameQueryRequest.java, v 0.1 2023-02-23 9:47 AM
 */
@Data
public class LakalaTerminalActiveQueryRequest extends LakalaBizRequest<LakalaTerminalActiveQueryResponse, LakalaMerchantApiDefinitionEnum> {

    /**
     * 商编
     */
    private String merId;


    /**
     * 商编
     */
    private String termId;


    /**
     * 来源
     * MICRO - 小微商户管理系统
     * CMMP - 招财考拉
     * MMS - 业务运营平台
     * TKSAAS - 拓客SAAS
     */
    private String source;

    /**
     * 终端设备序列号
     */
    private String ts;

    /**
     * 终端设备序列号
     */
    private String nonce;

}