/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.response.trade.info.LakalaBankPayRefundQueryInfoResponse;
import lombok.Data;

import java.util.List;

/**
 * 刷卡订单退款查询接口
 *
 * @author wangyi
 * @version LakalaBankPayRefundQueryResponse.java, v 0.1 2022-03-04 17:23
 */
@Data
public class LakalaBankPayTransQueryResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 8171302869680212126L;
    /**
     * 支付订单号
     */
    private String payOrderNo;

    /**
     * 商户订单号
     */
    private String outOrderNo;

    /**
     * 商户请求流水号
     */
    private String outTradeNo;

    /**
     * 交易商户号
     */
    private String transMerchantNo;

    /**
     * 交易终端号
     */
    private String transTermNo;

    /**
     * 结算商户号
     */
    private String merchantNo;

    /**
     * 结算终端号
     */
    private String termNo;

    /**
     * 订单金额
     */
    private Long totalAmount;

    /**
     * 订单交易信息列表
     */
    private List<LakalaBankPayRefundQueryInfoResponse> orderTradeInfoList;

    /**
     * DCC\EDC标志
     */
    private String dccFlg;

    /**
     * DCC转EDC时间
     */
    private String dccChgTm;

    /**
     * 汇率
     */
    private String bilRat;

    /**
     * 币种
     */
    private String bilCcy;

    /**
     * DCC交易金额
     */
    private String bilAmt;

    /**
     * 授权号
     */
    private String autCod;
}