/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.response.settle;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 提现结果查询
 *
 * @author liluqing
 * @version LakalaWithdrawQueryResponse.java, v 0.1 2023-02-28 14:32
 */
@Data
public class LakalaWithdrawQueryResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -3075923326650824594L;

    /**
     * 钱包ID (选填)
     * 示例：192203010752
     */
    private String ewalletId;

    /**
     * 请求日期 (选填)
     * 示例：20220406
     */
    private String reqDate;

    /**
     * 提款流水号 (选填)
     * 示例：220406170105809334963032
     */
    private String drawJnl;

    /**
     * 提款金额（元）：含手续费 (选填)
     * 示例：2.00
     */
    private String drawAmt;

    /**
     * 手续费（元） (选填)
     * 示例：1.00
     */
    private String drawFee;

    /**
     * 提款模式(D0/D1) (选填)
     * 示例：D0
     */
    private String drawMode;

    /**
     * 结算模式（01主动提款 02自动结算） (选填)
     * 示例：01
     */
    private String batchAutoSettle;

    /**
     * 自动结算批次号 (选填)
     * 示例：22040720321314665477340
     */
    private String batchNo;

    /**
     * 结算账户号（脱敏） (选填)
     * 示例：622260*1610
     */
    private String acctNo;

    /**
     * 结算账户名（脱敏） (选填)
     * 示例：*雪松
     */
    private String acctName;

    /**
     * 提款状态 (选填)
     * 示例：DRAW.ACCEPTED 提款已受理<br>DRAW.FREEZE 提款冻结<br>DRAW.PROCESSING 提款处理中<br>DRAW.SUCCESS 提款成功<br>DRAW.FAILED 提款失败
     */
    private String drawState;

    /**
     * 结果信息 (选填)
     * 示例：交易成功
     */
    private String memo;

    /**
     * 商户订单号 (选填)
     */
    private String merOrderNo;

    /**
     * 结算流水号 (选填)
     * 交易成功
     */
    private String settleNo;

    /**
     * 完成时间 (选填)
     * 示例：2022-04-06 17:01:08
     */
    private String completeTime;

    /**
     * 创建时间 (选填)
     * 示例：2022-04-06 17:01:05
     */
    private String createdTime;

}