/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.settle;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 拉卡拉账户余额查询
 *
 * @author liluqing
 * @version LakalaSettleQueryAcctInfoResponse.java, v 0.1 2022-03-08 10:32
 */
@Data
public class LakalaSettleQueryAcctInfoResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 435868011587447863L;

    /**
     * 户名 (必填参数)
     */
    private String accName;

    /**
     * 账号 (必填参数)
     * 02001+15位+退货账户标识（04）
     */
    private String accNo;

    /**
     * 开户行名称 (必填参数)
     */
    private String bankName;

    /**
     * 行号 (必填参数)
     */
    private String bankNo;

    /**
     * 余额 (必填参数)
     * 单位：分
     */
    private String balance;

    /**
     * 接口状态 (必填参数)
     */
    private Boolean sucess;

    /**
     * 账户类型 (必填参数)
     * 00 - 正常账户 01 - 公共账户
     */
    private String accType;

    /**
     * 查询流水 (必填参数)
     */
    private String qryNo;

    /**
     * 商户号 (必填参数)
     */
    private String merId;

    /**
     * 余额查询标识 (必填参数)
     * 1-联机余额<br>2-数字货币余额<br>3-暂缓结算余额<br>4-退货账户余额
     */
    private String balanceFlag;
}