package com.fshows.lakala.response.merchant;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * @author liangyuanping
 * @version LakalaWechatRealNameQueryResponse.java, v 0.1 2023-02-23 9:50 AM
 */
@Data
public class LakalaWechatRealNameQueryResponse extends LakalaBizResponse {

    /**
     * 拉卡拉内部商户号
     */
    private String merInnerNo;

    /**
     * 子商户号
     */
    private String subMchId;
    /**
     * 渠道号（建议传入，能具体定位用的渠道，仅支持拉卡拉渠道查询）
     */
    private String channelId;
    /**
     * 从业机构号
     */
    private String receOrgNo;
    /**
     * 申请编号
     */
    private String applymentId;
    /**
     * 申请状态
     *
     * APPLYMENT_STATE_FAIL：提交失败； APPLYMENT_STATE_COMMIT：已提交；
     * 微信实名状态：
     * APPLYMENT_STATE_WAITTING_FOR_AUDIT：审核中；APPLYMENT_STATE_EDITTING：编辑中；APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT：待确认联系信息；APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON：待账户验证；APPLYMENT_STATE_PASSED：审核通过； APPLYMENT_STATE_REJECTED：审核驳回； APPLYMENT_STATE_FREEZED：已冻结； APPLYMENT_STATE_CANCELED：已作废。
     */
    private String applymentState;
    /**
     * 微信认证状态：
     * AUTHORIZE_STATE_UNAUTHORIZED：未授权
     * AUTHORIZE_STATE_AUTHORIZED ：已授权
     */
    private String authorizeState;
    /**
     * 报备渠道
     */
    private String registerChannel;
    /**
     * 实名认证类型
     * WXZF:微信
     * ZFBZF:支付宝
     */
    private String realNameType;
    /**
     * 1、当申请单状态为APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT、APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON、APPLYMENT_STATE_PASSED、APPLYMENT_STATE_FREEZED时，会返回二维码图片。2、可用img标签直接加载该图片。示例如下：<’img src=”data:image/png;base64,iVBORw0KGgoAAAANSU=” style=”display: block;”>
     */
    private String qrcodeData;
    /**
     * 驳回参数
     */
    private String rejectParameter;
    /**
     * 驳回原因
     */
    private String rejectReason;

}