/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.request.trade.pay.LakalaLocationInfoRequest;
import com.fshows.lakala.response.trade.order.LakalaRefundResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 拉卡拉退款申请接口
 *
 * @author liluqing
 * @version LakalaRefundRequest.java, v 0.1 2022-03-07 13:51
 */
@Data
public class LakalaRefundRequest extends LakalaBizRequest<LakalaRefundResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -8709086713880391468L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 商户交易流水号 (必填参数)
     * 商户系统唯一
     */
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 退款金额 (必填参数)
     * 单位分，整数数字型字符
     */
    @NotBlank
    @Length(max = 12, message = "退款金额长度不能超过12")
    private String refundAmount;

    /**
     * 退款原因 (选填)
     * 退款原因描述
     */
    @Length(max = 32, message = "退款原因长度不能超过32")
    private String refundReason;

    /**
     * 原商户交易流水号 (选填)
     * 下单时的商户请求流水号（退款时origin_out_trade_no，origin_trade_no，origin_log_no必送其一）
     */
    @Length(max = 32, message = "原商户交易流水号长度不能超过32")
    private String originOutTradeNo;

    /**
     * 原拉卡拉交易流水号 (选填)
     * 下单成功时，返回的拉卡拉交易流水。 origin_out_trade_no、origin_log_no、origin_trade_no至少一个必填，同时存在时优先级顺序如下： origin_trade_no、origin_log_no、origin_out_trade_no。
     */
    @Length(max = 32, message = "原拉卡拉交易流水号长度不能超过32")
    private String originTradeNo;

    /**
     * 原对账单流水号 (选填)
     * 对账单中的交易流水。 origin_out_trade_no、origin_log_no、origin_trade_no至少一个必填，同时存在时优先级顺序如下： origin_trade_no、origin_log_no、origin_out_trade_no。
     */
    @Length(max = 14, message = "原对账单流水号长度不能超过14")
    private String originLogNo;

    /**
     * 地址位置信息 (必填参数)
     * 地址位置信息，风控要求必送
     */
    @NotNull
    private LakalaLocationInfoRequest locationInfo;

}