/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.trade.order.LakalaBankPayOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 刷卡订单查询接口
 *
 * @author wangyi
 * @version LakalaBankPayOrderQueryRequest.java, v 0.1 2022-03-04 17:22
 */
@Data
public class LakalaBankPayOrderQueryRequest extends LakalaBizRequest<LakalaBankPayOrderQueryResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -7418393649769709591L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;
    /**
     * 商户交易流水号 (选填)
     */
    private String outOrderNo;

    /**
     * 支付订单号 (选填)
     */
    private String payOrderNo;

    /**
     * 渠道编号 (选填)
     */
    private String channelId;
}