/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaEwalletBalanceQueryResponse;
import lombok.Data;

/**
 * 账管家余额查询
 *
 * @author liluqing
 * @version LakalaEwalletBalanceQueryRequest.java, v 0.1 2023-02-28 14:43
 */
@Data
public class LakalaEwalletBalanceQueryRequest extends LakalaBizRequest<LakalaEwalletBalanceQueryResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = -727852660595907292L;

    /**
     * bmcp机构号
     */
    private String orgNo;

    /**
     * 商户号
     */
    private String merchantNo;

    /**
     * 账号（若该参数上送，则payType将无效）
     */
    private String payNo;

    /**
     * 账号类型（01：收款账户，02：付款账户，03：分账商户账户，04：分账接收方账户，05：充值代付账户，06：结算代付账户）- 未上送则默认为01
     */
    private String payType;
}