package com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaApplyActiveSettleResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author liangyuanping
 * @version LakalaApplyActiveSettleRequest.java, v 0.1 2023-02-15 2:49 PM
 */
@Data
public class LakalaApplyActiveSettleRequest extends LakalaBizRequest<LakalaApplyActiveSettleResponse, LakalaSettleApiDefinitionEnum> {
    /**
     * 接口版本号
     */
    @NotBlank(message = "接口版本号不能为空")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文）
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank(message = "订单编号不能为空")
    private String orderNo;
    /**
     * 机构代码
     */
    @NotBlank(message = "机构代码不能为空")
    private String orgCode;
    /**
     * 拉卡拉内部商户号 （拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准。）
     */
    private String merInnerNo;
    /**
     * 银联商户号（拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准。）
     */
    private String merCupNo;
}