/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 订单手续费查询
 *
 * @author liluqing
 * @version LakalaQueryRateFeeResponse.java, v 0.1 2022-03-09 10:49
 */
@Data
public class LakalaQueryRateFeeResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -3851087416866911428L;

    /**
     * 商户号 (必填参数)
     * 示例：822162070110095
     */
    @NotBlank
    private String merchantNo;

    /**
     * 终端号 (选填)
     * 示例：B0097326
     */
    private String termNo;

    /**
     * 交易流水号 (选填)
     * 示例：66210001790062
     */
    private String logNo;

    /**
     * 交易金额 (选填)
     * 示例：0.98（撤销退款交易金额为-x.xx）
     */
    private String tradeAmount;

    /**
     * 交易时间 (选填)
     * 示例：16:22:31
     */
    private String tradeTime;

    /**
     * 交易日期 (选填)
     * 示例：2020-04-03
     */
    private String tradeDate;

    /**
     * 清分日期 (选填)
     * 示例：2020-04-03
     */
    private String clearDate;

    /**
     * 结算金额 (选填)
     * 示例：0.97（撤销退款交易金额为-x.xx）
     */
    private String settleAmount;

    /**
     * 交易手续费 (选填)
     * 示例：0.01（撤销退款交易金额为-x.xx）
     */
    private String feeAmount;

    /**
     * 计费状态 (选填)
     * 示例：03 已清分
     */
    private String tradeState;
}